% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prisma.r
\name{prisma}
\alias{prisma}
\title{generate PRISMA statement flow chart}
\source{
\url{http://www.prisma-statement.org/PRISMAStatement/FlowDiagram.aspx}
}
\usage{
prisma(found, found_other, no_dupes, screened, screen_exclusions, full_text,
  full_text_exclusions, qualitative, quantitative, ..., dpi = 72)
}
\arguments{
\item{found}{Records found through database searching}

\item{found_other}{Additional records identified through other sources}

\item{no_dupes}{Records after duplicates removed}

\item{screened}{Records screened}

\item{screen_exclusions}{Records excluded}

\item{full_text}{Full-text articles assessed for eligibility}

\item{full_text_exclusions}{Full-text articles excluded with reasons}

\item{qualitative}{Studies included in qualitative analysis}

\item{quantitative}{Studies included in quantitative synthesis
(meta-analysis)}

\item{...}{Further arguments are passed to \code{grViz}}

\item{dpi}{Dots per inch, 72 is the default here, and in \code{DiagrammeR}
itself it claims to be 96. Varying the DPI (which is done in the DOT file)
unfortunately does not get detected by the downstream processing by the
'htmlwidgets' package. To overcome this, the user can add `height` and
`width` arguments which are passed through. It is easy to for scaled graphs
to fall off the canvas, or be crushed into the top-left corner, and
unfortunately this requires trial and error. Increasing DPI over 72 with
this setting tends to truncate the graph. On the other hand, leaving the
DPI at 72 and increasing both height and width appears to consistently give
higher resolution images.}
}
\description{
generate PRISMA statement flow chart for use in retrospective medical
research
}
\examples{
prisma(1, 2, 3, 4, 5, 6, 7, 8, 9)
}
