% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PPclassify.R
\name{PP.classify}
\alias{PP.classify}
\title{predict projection pursuit classification tree}
\usage{
PP.classify(Tree.result, test.data, Rule, true.class=NULL,...)
}
\arguments{
\item{Tree.result}{PPtreeclass object}

\item{test.data}{the test dataset}

\item{Rule}{split rule 1: mean of two group means
2: weighted mean of two group means - weight with group size
3: weighted mean of two group means - weight with group sd
4: weighted mean of two group means - weight with group se
5: mean of two group medians
6: weighted mean of two group medians - weight with group size
7: weighted mean of two group median - weight with group IQR
8: weighted mean of two group median - weight with group IQR and size
9: cutoff that minimize error rates in each node}

\item{true.class}{true class of test dataset if available}

\item{...}{arguments to be passed to methods}
}
\value{
predict.class predicted class

predict.error number of the prediction errors
}
\description{
Predict class for the test set and calculate prediction error.
After finding tree structure, predict class for the test set and calculate prediction error.
}
\examples{
data(iris)
n <- nrow(iris)
tot <- c(1:n)
n.train <- round(n*0.9)
train <- sample(tot,n.train)
test <- tot[-train]
Tree.result <- PP.Tree.class(iris[train,5],iris[train,1:4],"LDA")
PP.classify(Tree.result,iris[test,1:4],1,iris[test,5])
}
\references{
Lee, YD, Cook, D., Park JW, and Lee, EK(2013)
PPtree: Projection pursuit classification tree,
Electronic Journal of Statistics, 7:1369-1386.
}
\keyword{tree}

