% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pof.R
\name{read_pof}
\alias{read_pof}
\title{Read POF microdata}
\usage{
read_pof(microdata, input_txt, vars = NULL)
}
\arguments{
\item{microdata}{A text file containing microdata from POF survey, available on official website: (select a microdata file, according to the appropriated select the dictionary and input zip file, according to the appropriated year, microdata folder and then, inside, data) - \url{https://ftp.ibge.gov.br/Orcamentos_Familiares/}.}

\item{input_txt}{A text file, related to the microdata, containing the input script for SAS, available on official website: (select the dictionary and input zip file, according to the appropriated select the dictionary and input zip file, according to the appropriated year, microdata folder and then, inside, documentation) - \url{https://ftp.ibge.gov.br/Orcamentos_Familiares/}.}

\item{vars}{Vector of variable names to be kept for analysis. Default is to keep all variables.}
}
\value{
A tibble with selected variables of the microdata, including the necessary survey design ones.
}
\description{
This function reads POF microdata.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/trabalho/9050-pesquisa-de-orcamentos-familiares.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
input_path <- pof_example(path="input_example.txt")
data_path <- pof_example(path="exampledata.txt")
pof.df <- read_pof(microdata=data_path, input_txt=input_path, vars=c("V0407","V0408"))}
}
\seealso{
\link[POFIBGE]{get_pof} for downloading, labeling, deflating and creating survey design object for POF microdata.\cr \link[POFIBGE]{pof_labeller} for labeling categorical variables from POF microdata.\cr \link[POFIBGE]{pof_deflator} for adding deflator variables to POF microdata.\cr \link[POFIBGE]{pof_design} for creating POF survey design object.\cr \link[POFIBGE]{pof_example} for getting the path of the POF toy example files.
}
