% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_function.R
\name{PO.EN}
\alias{PO.EN}
\title{A robust presence-only model with Elastic Net penalty}
\usage{
PO.EN(x,y,o.iter=5, i.iter=5, lambda=.01,alpha=.5,
true.prob=0.5,beta_start,epsilon=1e-4, gram.input=FALSE,XtX.input=0,
ytx.input=0,XtX_reduce.input)
}
\arguments{
\item{x}{Input design matrix. Should not include the intercept vector.}

\item{y}{Response variable. Should be a binary vector, such that \eqn{0} represents background observations and \eqn{1} represents presence observations.}

\item{o.iter}{Number of outer loop iteration.}

\item{i.iter}{Number of inner loop iteration.}

\item{lambda}{A user supplied Elastic Net penalty parameter.}

\item{alpha}{The elastic net mixing parameter, where \eqn{0\le}\code{alpha}\eqn{\le 1}.}

\item{true.prob}{The  prevalence parameter, should be provided by users. Can be tuned in the cross-validation function.}

\item{beta_start}{A user supplied starting coefficients vector.}

\item{epsilon}{The threshold for stopping the coordinate descent algorithm.}

\item{gram.input}{The function allows users to feed the gram matrix for fasting computation. The default setting is False, and the function
compute the gram matrix for computation.}

\item{XtX.input}{If gram.input is TRUE, users should supply the corresponding gram matrix X'X.}

\item{ytx.input}{If gram.input is TRUE, users should supply the product of y'X.}

\item{XtX_reduce.input}{If gram.input is TRUE, users should supply a matrix of X'X without the diagnol entries.}
}
\value{
\code{beta}  The fitting vector of the coefficients, the intercept is included.
}
\description{
Fit a logistic regression with presence-only response via penalized maximum likelihood.
The regularization path is computed for the elastic-net penalty at a pair values of lambda and the prevalence parameter.
}
\details{
The function fits a presence-only model with an elastic net penalty.
}
\examples{
data(example.data) # example datasets, including training dataset and testing dataset
train_data<-example.data$train.data
y_train=train_data$response;x_train=train_data[,-1]  # response and design matrix of training data
test_data<-example.data$test.data
y_test=test_data$response;x_test=test_data[,-1]  # response and design matrix of testing data
PO.EN.beta<-PO.EN(x_train,y_train,lambda=0.1,
           true.prob=sum(y_train)/length(y_train),beta_start=rep(0,ncol(x_train)+1))
predictions<-PO.EN.predict(x_test,PO.EN.beta)
pROC::roc(y_test~predictions)
}
