% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xd.avt.R
\name{xd.avt}
\alias{xd.avt}
\title{Download data from Alpha Vantage}
\usage{
xd.avt(ticker,type,size="full",apikey,interval)
}
\arguments{
\item{ticker}{:the ticker for desired financial security. e.g. AAPL, MSFT}

\item{type}{:data type; usable values: "TIME_SERIES_INTRADAY", "TIME_SERIES_DAILY", "TIME_SERIES_DAILY_ADJUSTED",
"TIME_SERIES_WEEKLY", "TIME_SERIES_WEEKLY_ADJUSTED", "TIME_SERIES_MONTHLY", "TIME_SERIES_MONTHLY_ADJUSTED"}

\item{size}{:the size of data downloaded; use "compact" for the latest 100 observations and "full" for at most the last 20
years as claimed by the website. However, most data only go back to Jan. 2000.}

\item{apikey}{:a string that is obtained by a onetime registration}

\item{interval}{:required for intraday data; usable values: "1min", "5min", "15min", "30min", "60min"}
}
\description{
This function will return time series data of financial securities from Alpha Vantage.
 Before using this function, a onetime registration is required to obtain a APIKEY, which is unique
 for users. Also, the key is valid for lifetime.
}
\examples{
# All parameters are required to be strings
# The example is to download Ford Motor Company's daily adjusted price.
# The apikey here is just for demonstration purposes.
T <- xd.avt("T","TIME_SERIES_DAILY","full","QB45BDBGP0O7W8TB")
}
