% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/welchManyOneTTest.R
\name{welchManyOneTTest}
\alias{welchManyOneTTest}
\alias{welchManyOneTTest.default}
\alias{welchManyOneTTest.formula}
\title{Welchs's Many-To-One Comparison Test}
\usage{
welchManyOneTTest(x, ...)

\method{welchManyOneTTest}{default}(x, g, alternative = c("two.sided",
  "greater", "less"), p.adjust.method = p.adjust.methods, ...)

\method{welchManyOneTTest}{formula}(formula, data, subset, na.action,
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = p.adjust.methods, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis.
Defaults to \code{two.sided}.}

\item{p.adjust.method}{method for adjusting p values
(see \code{\link{p.adjust}}).}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Welchs's t-test for multiple comparisons with one control.
}
\details{
For many-to-one comparisons in an one-factorial layout
with normally distributed residuals and unequal variances
Welch's t-test can be used. A total of \eqn{m = k-1}
hypotheses can be tested. The null hypothesis
H\eqn{_{i}: \mu_0(x) = \mu_i(x)} is tested in the two-tailed test
against the alternative
A\eqn{_{i}: \mu_0(x) \ne \mu_i(x), ~~ 1 \le i \le k-1}.

This function is basically a wrapper function for
\code{\link[stats]{t.test}(..., var.equal = FALSE)}. The p-values for the test
are calculated from the t distribution
and can be adusted with any method that is implemented in
\code{\link[stats]{p.adjust.methods}}.
}
\examples{
set.seed(245)
mn <- rep(c(1, 2^(1:4)), each=5)
sd <- rep(1:5, each=5)
x <- mn + rnorm(25, sd = sd)
g <- factor(rep(1:5, each=5))

fit <- aov(x ~ g)
shapiro.test(residuals(fit))
bartlett.test(x ~ g) # var1 != varN
anova(fit)
summary(welchManyOneTTest(x, g, alternative = "greater", p.adjust="holm"))

}
\references{
Welch, B. L. (1947) The generalization of "Student's" problem
 when several different population variances are involved,
 \emph{Biometrika} \bold{34}, 28--35.

 Welch, B. L. (1951) On the comparison of several mean values:
 An alternative approach, \emph{Biometrika} \bold{38}, 330--336.
}
\seealso{
\code{\link[stats]{pairwise.t.test}}, \code{\link[stats]{t.test}},
\code{\link[stats]{p.adjust}}, \code{\link{tamhaneDunnettTest}}
}
\concept{ManyToOneComparisons}
\keyword{htest}
