% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsim.lam.r
\name{plsim.lam}
\alias{plsim.lam}
\alias{plsim.lam.formula}
\alias{plsim.lam.default}
\title{Select lambda for Penalized Profile Least Squares Estimator}
\usage{
plsim.lam(\dots)

\method{plsim.lam}{formula}(formula, data, \dots)

\method{plsim.lam}{default}(xdat=NULL, ydat, zdat, h, zetaini=NULL, penalty="SCAD", 
lambdaList=NULL, l1_ratio_List=NULL, lambda_selector="BIC", verbose=TRUE, seed=0, \dots)
}
\arguments{
\item{\dots}{additional arguments.}

\item{formula}{a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment containing the variables in the model.}

\item{xdat}{input matrix (linear covariates). The model reduces to a single index model when \code{x} is NULL.}

\item{zdat}{input matrix (nonlinear covariates). \code{z} should not be NULL.}

\item{ydat}{input vector (response variable).}

\item{h}{bandwidth.}

\item{zetaini}{initial coefficients, optional (default: NULL). It could be obtained by the function \code{\link{plsim.ini}}.
\code{zetaini[1:ncol(z)]} is the initial coefficient vector \eqn{\alpha_0},
and \code{zetaini[(ncol(z)+1):(ncol(z)+ncol(x))]} is the initial coefficient vector \eqn{\beta_0}.}

\item{penalty}{string, optional (default="SCAD"). It could be "SCAD", "LASSO" or "ElasticNet".}

\item{lambdaList}{candidates for lambda selection. \code{lambda} is a constant that multiplies the penalty term. 
If \code{lambdaList} is NULL, function \link{plsim.lam} will automatically set it.}

\item{l1_ratio_List}{candidates for l1_ratio selection. \code{l1_ratio} is a constant that balances the importances 
of L1 norm and L2 norm for "ElasticNet". If \code{l1_ratio_List} is NULL, function \link{plsim.lam} ranges from 0 to 1 with 
an increment 0.1.}

\item{lambda_selector}{the criterion to select lambda (and l1_ratio), default: "BIC".}

\item{verbose}{bool, default: TRUE. Enable verbose output.}

\item{seed}{int, default: 0.}
}
\value{
\item{goodness_best}{the AIC (or BIC) statistics with \code{lambda_best}.}
\item{lambda_best}{lambda selected by AIC or BIC.}
\item{l1_ratio_best}{l1_ratio selected by AIC or BIC.}
\item{lambdaList}{\code{lambdaList} automatically selected when inputting NULL.}
}
\description{
Use AIC or BIC to 
choose the regularization parameters for Penalized Profile least squares (PPLS) estimation.
}
\examples{

# EXAMPLE 1 (INTERFACE=FORMULA)
# To select the regularization parameters based on AIC.

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")
beta = matrix(4,1,1)

x = matrix(1,n,1)
z = matrix(runif(n*2),n,2)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)


fit_plsimest = plsim.est(y~x|z)

# Select the regularization parameters by AIC
res = plsim.lam(y~x|z,h=fit_plsimest$data$h,zetaini = fit_plsimest$zeta,
             lambda_selector='AIC')


# EXAMPLE 2 (INTERFACE=DATA FRAME)
# To select the regularization parameters based on AIC.

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")
beta = matrix(4,1,1)

x = rep(1,n)
z1 = runif(n)
z2 = runif(n) 
X = data.frame(x)
Z = data.frame(z1,z2)

x = data.matrix(X)
z = data.matrix(Z)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

fit_plsimest = plsim.est(xdat=X,zdat=Z,ydat=y)

# Select the regularization parameters by AIC
res2 = plsim.lam(xdat=X,ydat=y,zdat=Z,h=fit_plsimest$data$h,
              zetaini = fit_plsimest$zeta, lambda_selector='AIC')

}
\references{
H. Liang, X. Liu, R. Li, C. L. Tsai. \emph{Estimation and testing for partially linear single-index models}.
Annals of statistics, 2010, 38(6): 3811.
}
