% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneComp_Coefficient_Exponent.R
\name{OneComp_Coefficient_Exponent}
\alias{OneComp_Coefficient_Exponent}
\title{Convert pharmacokinetic parameters for one compartment model}
\usage{
OneComp_Coefficient_Exponent(A,alpha,A.sd=NA,alpha.sd=NA,
           covar=c(Aalpha=NA))
}
\arguments{
\item{A}{parameter in one compartment model "Aexp(-alpha)"}

\item{alpha}{parameter in one compartment model "Aexp(-alpha)"}

\item{A.sd}{standard error of A}

\item{alpha.sd}{standard error of alpha}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with parameters (A and alpha)
in one compartment model "Aexp(-alpha)"
}
\examples{
OneComp_Coefficient_Exponent(A=0.125,alpha=0.5,A.sd=0.002,alpha.sd=0.009)
}
\references{
\url{www.nonmemcourse.com/convert.xls}
}
