% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaners.R
\name{clean.conc.na}
\alias{clean.conc.na}
\title{Handle NA values in the concentration measurements as requested by the user.}
\usage{
clean.conc.na(conc, time, ..., options = list(), conc.na = NULL, check = TRUE)
}
\arguments{
\item{conc}{Measured concentrations}

\item{time}{Time of the measurement of the concentrations}

\item{\dots}{Additional items to add to the data frame}

\item{options}{List of changes to the default PKNCA options (see
\code{PKNCA.options()})}

\item{conc.na}{How to handle NA concentrations?  Either 'drop' or a number to
impute.}

\item{check}{Run \code{\link[=assert_conc_time]{assert_conc_time()}}?}
}
\value{
The concentration and time measurements (data frame) filtered
and cleaned as requested relative to NA in the concentration.
}
\description{
NA concentrations (and their associated times) will be removed then the BLQ
values in the middle
}
\seealso{
Other Data cleaners: 
\code{\link{clean.conc.blq}()}
}
\concept{Data cleaners}
