\name{data.to.PIGE}
\alias{data.to.PIGE}
\title{Generate data for Gene- and Pathway-environment interaction}
\usage{
  data.to.PIGE(data, data.pathway, list.gene.snp,
    choice.pathway = NULL)
}
\arguments{
  \item{data}{a data frame containing the variables in the
  model and the SNP.}

  \item{data.pathway}{A data frame (Gene X Pathway) of 0
  and 1 values. The rownames (gene name considered) and the
  colnames (names of the studied pathways).  have to be
  specified. The value 1 indicates that a gene is included
  in the corresponding pathway.}

  \item{list.gene.snp}{List containing for each gene the
  names of the SNPs belonging to it. This list could be
  generated by \code{data.to.list.gene.snp} function.}

  \item{choice.pathway}{names or indice of the pathway to
  be analysed.}
}
\value{
  The returned value is a list containing:
  \item{data.pathway}{ A data frame (Gene X Pathway) of 0
  and 1 values similar as \code{data.pathway} but only for
  the selected pathways.} \item{tab.snp.gene}{A matrix with
  in the first column the names of the SNPs and the
  corresponding gene on the second column. Note that a SNPs
  could belong to several gene.} \item{snp.selected}{A
  vector of names corresponding to the SNPs analalysed.}
}
\description{
  The data.to.PIGE function prepare your data to be
  analysed by the functions \code{\link{permutation.snp}}
  and \code{\link{compute.p.snp.obs}}.
}
\examples{
data(data.pathway)
data(data.pige)
data(list.gene.snp)
#Example: one pathway
res1 <-data.to.PIGE(data=data.pige,data.pathway=data.pathway,
list.gene.snp=list.gene.snp,choice.pathway=c(2))
#Example: two pathways
res <-data.to.PIGE(data=data.pige,data.pathway=data.pathway
,list.gene.snp=list.gene.snp,choice.pathway=c(1,2))
}
\author{
  Benoit Liquet
  \email{benoit.liquet@isped.u-bordeaux2.fr}\cr Therese
  Truong \email{therese.truong@inserm.fr}
}

