% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIB.R
\name{BIB}
\alias{BIB}
\title{Balanced Incomplete binary Blocks Designs}
\usage{
BIB(m)
}
\arguments{
\item{m}{Dimension of the projective geometry defined on GF(2)}
}
\value{
A LIST of:
\enumerate{
 \item \code{V }{Number of treatments in the BIBD.}
 \item \code{B }{Number of blocks of the BIBD.}
 \item \code{R }{Repetition of each treatment.}
 \item \code{K }{Size of each block.}
 \item \code{BIB }{The configuration of the BIBD.}
}
}
\description{
Gives the configuration of a Balanced Incomplete binary Blocks
Designs (BIBD) using a projective geometry on a Galois Field of order 2 GF(2).
}
\examples{

m<-4
X<-BIB(m)   #BIB from PG(4,2)

}
\author{
Mohamed Laib, Abla Boudraa and Zebida Gheribi-Aoulmi
}
\references{
D. Dugué Traité de statistique théorique et appliquée, Masson et Cie, 1958.
}

