% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_SCALED_SCORE.R
\name{scaled.score}
\alias{scaled.score}
\title{Scaling the probabilities}
\usage{
scaled.score(probs, score = 600, odd = 50/1, pdo = 20)
}
\arguments{
\item{probs}{Model predicted probabilities of default.}

\item{score}{Specific score for selected odd (for argument \code{odd}). Default is 600.}

\item{odd}{Odd (good/bad) at specific score (for argument \code{score}). Default is 50/1.}

\item{pdo}{Points for double the odds. Default is 20.}
}
\value{
The command \code{scaled.score} returns a vector of scaled scores.
}
\description{
\code{scaled.score} performs scaling of the probabilities for a certain set up. User has to select
three parameters (\code{score, odd, pdo}), while the probabilities (\code{probs}) are usually
predictions of the final model.
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#run stepMIV
res <- stepMIV(start.model = Creditability ~ 1, 
	   miv.threshold = 0.02, 
	   m.ch.p.val = 0.05,
	   coding = "WoE",
	   db = loans)
final.model <- res$model
summary(final.model)$coefficients
#overview of development data base
head(res$dev.db)
#predict probabilities using the final model
loans$probs <- predict(final.model, type = "response", newdata = res$dev.db)
#scale probabilities to scores
loans$score <- scaled.score(probs = loans$probs, score = 600, odd = 50/1, pdo = 20)
#check AUC of probabilities and score
auc.model(predictions = loans$probs, observed = loans$Creditability)
auc.model(predictions = loans$score, observed = ifelse(loans$Creditability == 0, 1, 0))
#note that higher score indicates lower probability of default
}
\references{
Siddiqi, N. (2012). Credit Risk Scorecards: Developing and Implementing Intelligent Credit Scoring,
John Wiley & Sons, Inc.
}
