\name{convertToPDFe}
\alias{convertToPDFe}
\title{Convert to pdfe}
\description{Converts an estimated probability density to a pdfe object type for plotting and analysis utilities within the PDFEstimator package.}
\usage{convertToPDFe(sample, x, pdf)}
\arguments{
  \item{sample}{original data sample estimated}
  \item{x}{estimated points}
  \item{pdf}{estimated probability density for each value in x}
}
\details{The plotting functionality available in the PDFEstimator package requires a pdfe object type, generated by the estimatePDF() function.  If an alternative estimation method is used, convertToPDFe() will convert it to a pdfe object type.  The data sample and the x,y values of the alternative estimate must be provided.}
\value{
\item{pdfe}{a pdfe object type.}
}
\references{Farmer, J. and D. Jacobs (2018). "High throughput nonparametric probability density estimation." PLoS One 13(5): e0196937.}
\author{Jenny Farmer, Donald Jacobs}
\seealso{estimatePDF, plot.PDFe, lines.PDFe, summary.PDFe, print.PDFe}
\examples{
#Estimates a gamma distribution with 1000 sample points using the density() function 
# and converts it to a pdfe object for advanced visual analysis.

sampleSize = 1000
sample = rgamma(sampleSize, shape = 1)
kde = density(sample)
kdeTOpdfe = convertToPDFe(sample, kde$x, kde$y)
plot(kdeTOpdfe, plotPDF = FALSE, plotSQR = TRUE, plotShading = TRUE, showOutlierPercent = 95)
}