% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_transition.R
\name{plot.transition}
\alias{plot.transition}
\title{Plot the transitions and matchings from a \code{transition} object}
\usage{
\method{plot}{transition}(x, ...)
}
\arguments{
\item{x}{the object to print}

\item{...}{further methods passed to or from methods, currently unused}
}
\value{
A plot of the predicted and actual transitions in a \code{transition}
  object, as well as the matchings between them
}
\description{
Plot the transitions and matchings from a \code{transition} object
}
\examples{
predictions <- (sample(1:100)\%\%2)
references  <- (sample(1:100)\%\%2)
window_size <- 7
transitions <- get_transition_info(predictions, references, window_size)
plot(transitions)
}
