% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals}
\alias{residuals}
\alias{residuals.clm}
\alias{residuals.lrm}
\alias{residuals.orm}
\alias{residuals.polr}
\alias{residuals.vglm}
\alias{residuals.ord}
\alias{residuals.PAsso}
\title{Extract Model Residuals}
\usage{
\method{residuals}{clm}(
  object,
  type = c("surrogate", "sign", "general", "deviance"),
  jitter = c("latent", "uniform"),
  jitter.uniform.scale = c("probability", "response"),
  nsim = 1L,
  ...
)

\method{residuals}{lrm}(
  object,
  type = c("surrogate", "sign", "general", "deviance"),
  jitter = c("latent", "uniform"),
  jitter.uniform.scale = c("probability", "response"),
  nsim = 1L,
  ...
)

\method{residuals}{orm}(
  object,
  type = c("surrogate", "sign", "general", "deviance"),
  jitter = c("latent", "uniform"),
  jitter.uniform.scale = c("probability", "response"),
  nsim = 1L,
  ...
)

\method{residuals}{polr}(
  object,
  type = c("surrogate", "sign", "general", "deviance"),
  jitter = c("latent", "uniform"),
  jitter.uniform.scale = c("probability", "response"),
  nsim = 1L,
  ...
)

\method{residuals}{vglm}(
  object,
  type = c("surrogate", "sign", "general", "deviance"),
  jitter = c("latent", "uniform"),
  jitter.uniform.scale = c("probability", "response"),
  nsim = 1L,
  ...
)

\method{residuals}{ord}(
  object,
  type = c("surrogate", "sign", "general", "deviance", "pearson", "working",
    "response", "partial"),
  jitter = c("latent", "uniform"),
  jitter.uniform.scale = c("probability", "response"),
  nsim = 1L,
  ...
)

\method{residuals}{PAsso}(object, draw_id = 1, ...)
}
\arguments{
\item{object}{An object of class \code{PAsso}.}

\item{type}{The type of residuals which should be returned. The alternatives
are: "surrogate" (default), "sign", "general", and "deviance". Can be abbreviated.
\describe{
  \item{\code{surrogate}}{surrogate residuals (Liu and Zhang, 2017);}
  \item{\code{sign}}{sign-based residuals;}
  \item{\code{general}}{generalized residuals (Franses and Paap, 2001);}
  \item{\code{deviance}}{deviance residuals (-2*loglik).}
}}

\item{jitter}{A character string specifying which method to use to generate the
surrogate response values. Current options are \code{"latent"} and
\code{"uniform"}. Default is \code{"latent"}.
\describe{
  \item{\code{latent}}{latent approach;}
  \item{\code{uniform}}{jittering uniform approach.}
}}

\item{jitter.uniform.scale}{A character string specifying the scale on which to perform
the jittering whenever \code{jitter = "uniform"}. Current options are
\code{"response"} and \code{"probability"}. Default is \code{"response"}.}

\item{nsim}{An integer specifying the number of replicates to use.
Default is \code{1L} meaning one simulation only of residuals.}

\item{...}{Additional optional arguments.}

\item{draw_id}{A number refers to the i-th draw of residuals.}
}
\value{
A numeric vector of class \code{c("numeric", "resids")} containing
the simulated surrogate residuals. Additionally, if \code{nsim} > 1,
then the result will contain the attributes:
\describe{
  \item{\code{draws}}{A matrix with \code{nsim} columns, one for each
  is a replicate of the surrogate residuals. Note, they correspond
  to the original ordering of the data;}
  \item{\code{draws_id}}{A matrix  with \code{nsim} columns. Each column
  contains the observation number each surrogate residuals corresponds to in
  \code{draws}. (This is used for plotting purposes.)}
}



A matrix of class \code{c("matrix", "resids")} containing
the simulated surrogate residuals used for the partial association
analysis in \code{PAsso}. Additionally, if \code{rep_num} > 1 in \code{PAsso},
then the result will contain the attributes:
\describe{
  \item{\code{draws}}{An array contains all draws of residuals.}
}


}
\description{
A generic function to simulate surrogate residuals for cumulative link
regression models using the latent method described in Liu and Zhang (2017).

It also support the sign-based residuals (Li and Shepherd, 2010), generalized
residuals (Franses and Paap, 2001), and deviance residuals for cumulative link
regression models.
}
\note{
Surrogate response values require sampling from a continuous distribution;
consequently, the result will be different with every call to
\code{surrogate}. The internal functions used for sampling from truncated
distributions are based on modified versions of
\code{\link[truncdist]{rtrunc}} and \code{\link[truncdist]{qtrunc}}.

For \code{"glm"} objects, only the \code{binomial()} family is supported.
}
\examples{
# Generate data from a quadratic probit model
set.seed(101)
n <- 2000
x <- runif(n, min = -3, max = 6)
z <- 10 + 3 * x - 1 * x^2 + rnorm(n)
y <- ifelse(z <= 0, yes = 0, no = 1)

# Scatterplot matrix
pairs(~ x + y + z)

# Misspecified mean structure
fm1 <- glm(y ~ x, family = binomial(link = "probit"))
diagnostic.plot(fm1)

# Correctly specified mean structure
fm2 <- glm(y ~ x + I(x ^ 2), family = binomial(link = "probit"))
diagnostic.plot(fm2)

# Load data
data("ANES2016")
PAsso_1 <- PAsso(responses = c("PreVote.num", "PID"),
                 adjustments = c("income.num", "age", "edu.year"),
                 data = ANES2016)

# Compute residuals
res1 <- residuals(PAsso_1)

}
\references{
Liu, Dungang and Zhang, Heping. Residuals and Diagnostics for Ordinal
Regression Models: A Surrogate Approach.
\emph{Journal of the American Statistical Association}.
\url{http://www.tandfonline.com/doi/abs/10.1080/01621459.2017.1292915?journalCode=uasa20}

Li, C., & Shepherd, B. E. (2010). Test of association between two ordinal
variables while adjusting for covariates. \emph{Journal of the American Statistical
Association}, 105(490), 612-620. \url{https://doi.org/10.1198/jasa.2010.tm09386}


Franses, Philip Hans, and Richard Paap. Quantitative models in marketing research.
Cambridge University Press, 2001.
\url{https://pdfs.semanticscholar.org/dad0/820f287a8cf5a4e8039549e35fc111fd86e5.pdf}
}
