% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_Normal.R
\name{power_Normal}
\alias{power_Normal}
\title{Power Calculations for One and Two Sample T-tests}
\usage{
power_Normal(n1 = NULL, n2 = NULL, power = NULL, sig.level = 0.05,
delta = NULL, sd1 = 1, sd2 = 1, equal.sample = TRUE,
alternative = c("two.sided", "one.sided"),
type = c("two.sample", "one.sample", "paired"),
df.method = c("welch", "classical"), strict = FALSE)
}
\arguments{
\item{n1}{sample size in group 1, or sample size in each group if equal.sample = TRUE}

\item{n2}{sample size in group 2}

\item{power}{power of test (1 minus Type II error probability)}

\item{sig.level}{significance level (Type I error probability)}

\item{delta}{true difference in means}

\item{sd1}{standard deviation for group 1}

\item{sd2}{standard deviation for group 2}

\item{equal.sample}{equal sample sizes for two groups, see details}

\item{alternative}{one- or two-sided test}

\item{type}{Type of t test}

\item{df.method}{Method for calculating the degrees of default. Possibilities are welch (the default) or classical.}

\item{strict}{Use strict interpretation in two-sided case}
}
\value{
Object of class "power.htest", a list of the arguments (including the computed one) augmented with note and method elements.
}
\description{
Compute power of t test, or determine parameters to obtain target power.
}
\details{
Exactly one of the parameters \code{n1}, \code{n2}, \code{delta}, \code{sd1}, \code{sd2}, \code{power}, and \code{sig.level} must be passed as NULL, and that parameter is determined from the others.
Notice that \code{sd1}, \code{sd2}, \code{sig.level} have non-NULL defaults, so NULL must be explicitly expressed if you want to compute them.\cr\cr
If \code{equal.sample = TRUE} is used, N in output will denote the number in each group.\cr\cr
}
\note{
'uniroot' is used to solve power equation for unknowns, 
so you may see errors from it, notably about inability to bracket the root when invalid arguments are given.
}
\examples{
# Calculate power, equal sizes
power_Normal(n1 = 150, delta = 5, sd1 = 20, sd2 = 10)
# Calculate power, unequal sizes
power_Normal(n1 = 150, delta = 5, n2 = 120, sd1 = 10)
# Calculate n1, equal sizes 
power_Normal(delta = 5,  power = 0.9, sd1 = 10, sd2 = 12)
}
