% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cPANIC.r
\name{panic04}
\alias{panic04}
\title{PANIC (2004) Non-Stationarity Tests on Common and Idiosyncratic Components}
\usage{
panic04(x, nfac, k1, criteria)
}
\arguments{
\item{x}{An object of class xts with each column being a time series}

\item{nfac}{An integer speciyfing the maximum number of factors allowed
while estimating the factor model.}

\item{k1}{an integer that is the maximum lag allowed in the ADF test.}

\item{criteria}{a character vector of length one with a value of either IC1, IC2, IC3, AIC1, BIC1, AIC3, BIC3, or eigen.
Choosing eigen makes the number of factors equal to the number of columns whose sum of eigenvalues is less than  or equal to .5.}
}
\value{
pooladf A data frame containing the pooled tests for the demeaned data,
idiosyncratic component, and the cointegration test. The first row is Fisher's method applied to
the p values of the respective test. The second row is the correction from PANIC (2004) applied to
the first row.

Common A data frame of the test results on the common component

adff A data frame containing pooled demeaned critical values,
demeaned error term critical values, demeaned
and detrended critical values, R squared for principle component,
and the significance of the error components.

nfac An integer specifying the maximum number of factors allowed
while estimating the factor model.

k1 An integer that is the maximum lag allowed in the ADF test.

criteria A character vector with a value of either IC1, IC2, IC3, AIC1, BIC1, AIC3, BIC3, or eigen.
 Choosing eigen makes the number of factors equal to the number of columns whose sum of eigenvalues is less than  or equal to .5.

func A character vector representing which function was run

ic A numeric vector containing the number of components that were estimated
}
\description{
Performs the tests on the idiosyncratic and common component from PANIC (2004).
}
\references{
Bai, Jushan, and Serena Ng. 
'A PANIC Attack on Unit Roots and Cointegration.'
Econometrica 72.4 (2004): 1127-1177. Print.
}

