% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSSP.R
\name{createSSP}
\alias{createSSP}
\title{Create Sound Speed Profiles}
\usage{
createSSP(
  x,
  f = 30000,
  nc = NULL,
  ncVars = c("salinity", "water_temp"),
  dropNA = TRUE
)
}
\arguments{
\item{x}{a data.frame with columns \code{UTC}, \code{Longitude}, and 
\code{Latitude} to create sound speed profiles for}

\item{f}{the frequency (Hz) to generate the profile for}

\item{nc}{netcdf file containing salinity and temperature data at depth, if
\code{NULL} (default) these will be downloaded from HYCOM servers}

\item{ncVars}{names of the salinity and temperature variables (in that order)
in your netcdf file, only change these if you are providing your own file 
to \code{nc}}

\item{dropNA}{logical flag to drop NA values from soundspeeed profile from outputs.
SSP will be calculated up to the maximum depth at each coordinate, which can vary. 
Setting this option to \code{FALSE} ensures that outputs are the same length for 
each coordinate, which can be useful}
}
\value{
a list with one element for each row of \code{x}, each element is a list
  containing \code{speed}, the sound speed (m/s), and \code{depth} (m)
}
\description{
Creates sound speed profiles (Depth vs Sound Speed) using temperature
  and salinity data downloaded from HYCOM data servers
}
\examples{
\dontrun{
# examples not run because they require internet connection
coords <- data.frame(UTC=as.POSIXct('2014-07-15 01:00:00', tz='UTC'),
                     Longitude = -119, Latitude = 33)
ssp <- createSSP(coords)
plot(x=ssp[[1]]$speed, y=-ssp[[1]]$depth, type='l')
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
