% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPgAnno.R
\name{addPgAnno}
\alias{addPgAnno}
\title{Add Spectrogram Annotations to Pamguard Database}
\usage{
addPgAnno(
  db,
  anno,
  tableName = NULL,
  channel = 1,
  source = c("manual", "aplose", "pammisc", "annomate", "raven"),
  format = c("\%m/\%d/\%Y \%H:\%M:\%OS", "\%m-\%d-\%Y \%H:\%M:\%OS",
    "\%Y/\%m/\%d \%H:\%M:\%OS", "\%Y-\%m-\%d \%H:\%M:\%OS"),
  tz = "UTC"
)
}
\arguments{
\item{db}{database file to add annotations to}

\item{anno}{annotations to add, must contain columns \code{UTC}, \code{Duration} (seconds),
\code{f1} (min freq Hz), and \code{f2} (max freq Hz). Any other columns matching columns in the database
will also be added}

\item{tableName}{name of the annotation table in the database}

\item{channel}{channel to display the annotations on}

\item{source}{annotation source. If \code{'manual'}, columns \code{UTC}, \code{DUration},
\code{f1}, and \code{f2} must be present. Other options will attempt to automate
conversion to these column names from specific output sources}

\item{format}{date format, default will try two variations of MDY HMS and YMD HMS}

\item{tz}{timezone of provided date}
}
\value{
Returns a dataframe of the rows added to the database
}
\description{
Add new annotations to an existing Pamguard Spectrogram Annotations
  table
}
\examples{
\dontrun{
myDb <- 'PamguardDatabase.sqlite3'
myAnno <- data.frame(UTC = '2021/10/23 12:10:10', Duration = .563, f1=2300, f2=3600)
addPgAnno(myDb, myAnno, tableName='Spectrogram_Annotation', source='manual')
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
