% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAMA.Cov.R
\name{PAMA.Cov}
\alias{PAMA.Cov}
\title{This function implements Bayesian inference of PAMA model with covariates.}
\usage{
PAMA.Cov(datfile, Covdatfile, nRe, iter = 1000, init = "EMM")
}
\arguments{
\item{datfile}{A matrix or dataframe. This is the data where our algorithm will work on. Each colomn denotes a ranker's ranking. The data should be in entity-based format.}

\item{Covdatfile}{A matrix or dataframe. Each column denotes a covariate.}

\item{nRe}{A number. Number of relevant entities}

\item{iter}{A number. Numner of iterations of MCMC. Defaulted as 1000.}

\item{init}{A string. This indicates which method is used to initiate the starting point of the aggregated ranking list. "mean" uses the sample mean. "EMM" uses the method from R package 'ExtMallows'.}
}
\value{
List. It contains Bayesian posterior samples of all the parameters and log-likelihood.
\enumerate{
  \item I.mat: posterior samples of I
  \item phi.mat: posterior samples of phi
  \item smlgamma.mat: posterior samples of gamma
  \item l.mat: posterior samples of log-likelihood.
  \item theta.mat: posterior samples of coefficients of covariates.
}
}
\description{
This function implements Bayesian inference of PAMA model with covariates.
}
\details{
The covariates are incoporated in the PAMA framework as indicators of group membership. That is, covariates are associated to group members via a logistic regression.
}
\examples{
a=NBANFL()
PAMA.Cov(t(a$NFLdata),a$NFLcov,nRe=10,iter=10)
\dontrun{PAMA.Cov(t(a$NFLdata),a$NFLcov,nRe=10,iter=1000)}

}
\references{
Wanchuang Zhu, Yingkai Jiang, Jun S. Liu, Ke Deng (2021) Partition-Mallows Model and Its Inference for Rank Aggregation. Journal of the American Statistical Association
}
\author{
Wanchuang Zhu, Yingkai Jiang, Jun S. Liu, Ke Deng
}
