% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multimodalView.R
\name{multimodalView}
\alias{multimodalView}
\title{multimodalView Function}
\usage{
multimodalView(
  modality1,
  modality2,
  group_oi = NULL,
  geneList,
  colorThreshold = 10,
  group_position = NULL,
  plotHeight = 10,
  titleName = "",
  colorMax = NULL,
  colorscale = FALSE,
  fileName = NULL,
  filePATH = NULL
)
}
\arguments{
\item{modality1}{Variation or Expression matrix/data frame. Rows represents
gene/proteins column represents group:donor (group and donor separated by :)}

\item{modality2}{Variation or Expression matrix/data frame. Rows represents
gene/proteins column represents group:donor (group and donor separated by :)}

\item{group_oi}{Optional, User-defined groups to consider and order}

\item{geneList}{Genes of interest to explore}

\item{colorThreshold}{User-defined color threshold in color space}

\item{group_position}{Default 1, use 2 when columns are donor:group format}

\item{plotHeight}{User-defined Plot size (in)}

\item{titleName}{Title of the plot}

\item{colorMax}{Maximum CV value in heatplot ("max", numeric or NULL)}

\item{colorscale}{Show color scale, TRUE or FALSE (default).}

\item{fileName}{User defined filename}

\item{filePATH}{User-defined output directory \emph{PATH} to save result}
}
\value{
Multimodal plot and data list
}
\description{
This function allows to visualize the multimodal view genes of interest
by celltypes/ groups defined by use
}
\examples{
\dontrun{
multimodalView(modality1=scrna_cv_res, modality2=scatac_cv_res, geneList)
}
}
\keyword{multimodalView}
