% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvSCsampleprofile.R
\name{cvSCsampleprofile}
\alias{cvSCsampleprofile}
\title{cvSCsampleprofile Function}
\usage{
cvSCsampleprofile(
  data_object,
  meanThreshold = NULL,
  cvThreshold = NULL,
  cl = 2,
  plot_log10 = FALSE,
  fileName = NULL,
  filePATH = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. Contains annotation table and
expression matrix or data frame. Rows represent gene/proteins column
represents participant samples (same as annotation table Sample column)}

\item{meanThreshold}{Average expression threshold to filter lowly expressed
genes Default is 0.1 (log2 scale)}

\item{cvThreshold}{Coefficient of variation threshold to select variable and
stable genes Default is 10 for single cell RNA (100*SD/mean)}

\item{cl}{Number of clusters. Use nCores-1 to run parallel. Default 2}

\item{plot_log10}{Optional, Plot CV vs Mean on log10 scale. Default FALSE}

\item{fileName}{User-defined file name, Default outputFile}

\item{filePATH}{User-defined output directory \emph{PATH} Default, current
directory}
}
\value{
PALMO object with CV list
}
\description{
This function allows to calculate Intra-donor variations in single cell data
at sample level over longitudinal timepoints and visualize in a CV vs Mean
plot. Plots stored in output directory.
}
\examples{
\dontrun{
palmo_obj <- cvSCsampleprofile(data_object=palmo_obj,
housekeeping_genes=c('GAPDH', 'ACTB'), fileName='scrna')
}
}
\keyword{cvSCsampleprofile}
