lgwt = function(N,a,b){
  
  N = N-1;
  N1=N+1
  N2 = N+2

  xu = seq(-1,1,len = N1)
  #Initial guess
  y = cos((2*(0:N)+1)*pi/(2*N+2))+(0.27/N1)*sin(pi*xu*N/N2)


  #Compute the zeros of the N+1 Legendre Polynomial
  #using the recursion relation and the Newton-Raphson method

  y0 = 2

  #Legendre-Gauss Vandermonde Matrix
   L = matrix(0,N1,N2)

  #Iterate until new points are uniformly within epsilon of old points
  
   while(max(abs(y-y0))>.Machine$double.eps){

      #Derivative of LGVM
      Lp = matrix(0,N1, N2)

      L[,1] = 1
      Lp[,1] = 0
      L[,2] = y
      Lp[,2] = 1
     
      for(k in 2:N1){
         L[,k+1] = ((2*k-1)*y*L[,k]-(k-1)*L[,k-1])/k
      }
      Lp = N2*(L[,N1]-y*L[,N2])/(1-y^2)
    
      y0 = y
      y = y0-L[,N2]/Lp
   }
  
   #Linear map from [-1,1] to [a,b]
   x =(a*(1-y)+b*(1+y))/2
   
   #Compute the weights
   w = (b-a)/((1-y^2)*Lp^2)*(N2/N1)^2
   
   list(x = x, w = w)

}
