% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latticeCombineLayer.R
\name{latticeCombineLayer}
\alias{latticeCombineLayer}
\title{Combine multiple lattice plots layerwise}
\usage{
latticeCombineLayer(trellis.list, ...)
}
\arguments{
\item{trellis.list}{A \code{list} containing \strong{lattice} plot objects.}

\item{...}{Additional arguments passed to \code{\link{as.layer}}.}
}
\value{
A single \strong{lattice} plot object.
}
\description{
This function combines multiple \strong{lattice} plot objects drawing each as 
a layer on top of the previous plots. Note that the global plot settings 
(e.g. xlim, ylim, ...) are taken from the first object. This is particularly 
useful when looping over large amounts of data using \code{\link{lapply}} 
(see examples).
}
\examples{
library(latticeExtra)
dat <- list(1:10,
            10:1,
            3:7,
            7:3)

plist <- lapply(seq(dat), function(i) {
 tmp <- xyplot(dat[[i]] ~ seq(dat[[i]]),
               type = "l", col = i)
})

p <- latticeCombineLayer(plist)

print(p)

}
\seealso{
\code{\link{as.layer}}.
}
\author{
Tim Appelhans
}
