% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimNN.R
\name{Optim.NN}
\alias{Optim.NN}
\title{Discover the best Neural Network for your data}
\usage{
Optim.NN(formula, data, p, criteria = c("success_rate", "ti_error",
  "tii_error"), includedata = FALSE, seed = NULL, maxhiddenlayers = 10,
  maxit = 500, MaxNWts = 2000, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ x1 + x2 + \dots}}

\item{data}{data frame from which variables specified in  \code{formula} are preferentially to be taken.}

\item{p}{a percentage of training elements}

\item{criteria}{this variable selects the criteria to select the best threshold. The default value is \code{success_rate}}

\item{includedata}{logicals. If TRUE the training and testing datasets are returned.}

\item{seed}{a single value, interpreted as an integer, or \code{NULL}. The default value is \code{NULL}, but for future checks of the model or models generated it is advisable to set a random seed to be able to reproduce it.}

\item{maxhiddenlayers}{the high number of hidden layers for the neural network considers.}

\item{maxit}{the maximum allowable number of weights. There is no intrinsic limit in the code, but increasing \code{MaxNWts} will probably allow fits that are very slow and time-consuming.}

\item{MaxNWts}{maximum number of iterations. Default 500.}

\item{...}{arguments passed to \code{\link[nnet]{nnet}}}
}
\value{
An object of class \code{Optim}. See \code{\link{Optim.object}}
}
\description{
\code{Optim.NN}  function allows to find the best \code{NN}.
}
\examples{
if(interactive()){
## Load a Dataset
data(AustralianCredit)
## Generate a model
modelFit <- Optim.NN(Y~., AustralianCredit, p = 0.7, seed=2018)
modelFit
}

}
