/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;

public class ScanexTileSource
extends AbstractOsmTileSource {
    private static String API_KEY = "4018C5A9AECAD8868ED5DEB2E41D09F7";
    private ScanexLayer Layer = ScanexLayer.IRS;
    private static double RADIUS_E = 6378137.0;
    private static double EQUATOR = 4.007501668557849E7;
    private static double E = 0.0818191908426;

    public ScanexTileSource(String url) {
        super("Scanex" + url, "http://maps.kosmosnimki.ru");
        ScanexLayer[] scanexLayerArray = ScanexLayer.values();
        int n = scanexLayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScanexLayer layer = scanexLayerArray[n2];
            if (url.equalsIgnoreCase(layer.getName())) {
                this.Layer = layer;
                break;
            }
            ++n2;
        }
    }

    public int getMaxZoom() {
        return 14;
    }

    public String getExtension() {
        return "jpeg";
    }

    public String getTilePath(int zoom, int tilex, int tiley) {
        int tmp = (int)Math.pow(2.0, zoom - 1);
        tiley = tmp - tiley - 1;
        return String.valueOf(this.Layer.getUri()) + "&apikey=" + API_KEY + "&x=" + (tilex -= tmp) + "&y=" + tiley + "&z=" + zoom;
    }

    public TileSource.TileUpdate getTileUpdate() {
        return TileSource.TileUpdate.IfNoneMatch;
    }

    public double latToTileY(double lat, int zoom) {
        double tmp = Math.tan(0.7853981633974483 * (1.0 + lat / 90.0));
        double pow = Math.pow(Math.tan(0.7853981633974483 + Math.asin(E * Math.sin(Math.toRadians(lat))) / 2.0), E);
        return (EQUATOR / 2.0 - RADIUS_E * Math.log(tmp / pow)) * Math.pow(2.0, zoom) / EQUATOR;
    }

    public double lonToTileX(double lon, int zoom) {
        return (RADIUS_E * lon * Math.PI / (90.0 * EQUATOR) + 1.0) * Math.pow(2.0, zoom - 1);
    }

    public double tileYToLat(int y, int zoom) {
        double lat = 0.0;
        double minl = -85.05112877980659;
        double maxl = 85.05112877980659;
        int i = 0;
        while (i < 60) {
            double c = this.latToTileY(lat, zoom);
            if (c < (double)y) {
                maxl = lat;
                lat -= (lat - minl) / 2.0;
            } else {
                minl = lat;
                lat += (maxl - lat) / 2.0;
            }
            ++i;
        }
        return lat;
    }

    public double tileXToLon(int x, int zoom) {
        return ((double)x / Math.pow(2.0, zoom - 1) - 1.0) * (90.0 * EQUATOR) / RADIUS_E / Math.PI;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScanexLayer {
        IRS("irs", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=BAC78D764F0443BD9AF93E7A998C9F5B"),
        SPOT("spot", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=F51CE95441284AF6B2FC319B609C7DEC");

        private String name;
        private String uri;

        private ScanexLayer(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

