% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openrepgrid.r
\docType{package}
\name{OpenRepGrid}
\alias{OpenRepGrid-package}
\alias{OpenRepGrid}
\title{\code{OpenRepGrid}: an R package for the analysis of repertory grids.}
\description{
\if{html}{\figure{logo.png}{options: style='float: right; padding-left: 10px;' alt='logo' width='120'}} The
\code{OpenRepGrid} package provides tools for the analysis of repertory grid data. The repertory grid is a method devised
by George Alexander Kelly in his seminal work "The Psychology of Personal Constructs" published in 1955. The
repertory grid has been used in and outside the context of Personal Construct Psychology (PCP) in a broad range of
fields. For an introduction into the technique see e.g. Fransella, Bell and Bannister (2003).
}
\note{
To get started with \code{OpenRepGrid} visit the project's home under \href{https://openrepgrid.org}{openrepgrid.org}.
On this site you will find tutorials, explanation about the theory, the analysis methods and the corresponding R
code.

To see how to cite the \code{OpenRepGrid} package, type \code{citation("OpenRepGrid")} into the R console.
}
\references{
Fransella, F., Bell, R. C., & Bannister, D. (2003). \emph{A Manual for Repertory Grid Technique (2. Ed.).}
Chichester: John Wiley & Sons.

Kelly, G. A. (1955). \emph{The psychology of personal constructs. Vol. I, II.} New York: Norton, (2nd printing: 1991,
Routledge, London, New York).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/markheckmann/OpenRepGrid}
}

}
\author{
\itemize{
\item Maintainer: Mark Heckmann (\href{https://markheckmann.de}{@markheckmann})
\item Contributors: Richard C. Bell, Alejandro García Gutiérrez (@j4n7), Diego Vitali (@artoo-git), José Antonio
González Del Puerto (@MindCartographer), Jonathan D. Raskin
\item How to contribute: You can \href{https://docs.openrepgrid.org/CONTRIBUTING.html}{contribute in various ways}.
The \code{OpenRepGrid} code is hosted on \href{https://github.com/markheckmann/OpenRepGrid}{GitHub}, where you can issue bug
reports or feature requests. You may email your request to the package maintainer.
}
}
\keyword{package}
\keyword{repgrid}
