% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLFlow_Class.R
\name{makeOMLFlow}
\alias{OMLFlow}
\alias{makeOMLFlow}
\title{Construct OMLFlow.}
\usage{
makeOMLFlow(flow.id = NA_integer_, uploader = NA_integer_, name,
  version = NA_character_, external.version = NA_character_, description,
  creator = NA_character_, contributor = NA_character_,
  upload.date = NA_character_, licence = NA_character_,
  language = "English", full.description = NA_character_,
  installation.notes = NA_character_, dependencies = NA_character_,
  bibliographical.reference = NULL, implements = NA_character_,
  parameters = NULL, components = NULL, qualities = NULL,
  tags = NA_character_, source.url = NA_character_,
  binary.url = NA_character_, source.format = NA_character_,
  binary.format = NA_character_, source.md5 = NA_character_,
  binary.md5 = NA_character_, source.path = NA_character_,
  binary.path = NA_character_, object = NULL)
}
\arguments{
\item{flow.id}{[\code{integer(1)}]\cr
ID of the flow. Generated by the server, based on name and version of the flow.
Ignored when uploaded manually.}

\item{uploader}{[\code{integer(1)}]\cr
The user that uploaded the flow. Added by the server. Ignored when uploaded manually.}

\item{name}{[\code{character(1)}]\cr
The name of the flow. Name-version combinations should be unique.\cr
Allowed characters: () [] a-z A-Z 0-9 . _ - +}

\item{version}{[\code{character(1)}]\cr
The version of the flow. Default is 1.0. Ignored at upload time.}

\item{external.version}{[\code{character(1)}]\cr
An external version, defined by the user. In combination with the name, it must be unique.}

\item{description}{[\code{character(1)}]\cr
A user description of the flow.}

\item{creator}{[\code{character}]\cr
Optional. The persons/institutions that created the flow.}

\item{contributor}{[\code{character}]\cr
Optional. (Minor) contributors to the workflow}

\item{upload.date}{[\code{character(1)}]\cr
The date on which the flow was uploaded.\cr
Format YYYY-mm-ddThh:MM:SS.
Added by the server. Ignored when uploaded manually.}

\item{licence}{[\code{character(1)}]\cr
Optional. Default is none, meaning Public Domain or "don't know/care".}

\item{language}{[\code{character(1)}]\cr
Optional. Starts with one upper case letter, rest is lower case. Default is English.}

\item{full.description}{[\code{character(1)}]\cr
Optional. Full description of the workflow, e.g, man pages filled in by tool.
This is a much more elaborate description than given in the 'description field'. It may include
information about all components of the workflow.}

\item{installation.notes}{[\code{character(1)}]\cr
Optional. Additional hints on how to run the flow.}

\item{dependencies}{[\code{character(1)}]\cr
Optional. The dependencies of the flow.}

\item{bibliographical.reference}{[\code{list}]\cr
An optional list containing information on bibliographical references in form of
\code{OMLBibRef}.}

\item{implements}{[\code{character(1)}]\cr
Ontological reference.}

\item{parameters}{[\code{list}]\cr
The parameters of the flow. A list containing
\code{\link{OMLFlowParameter}s}.}

\item{components}{[\code{list}]\cr
A list containing \code{\link{OMLFlow}s}. Typically components of a workflow or
subfunctions of an algorithm (e.g. kernels). Components can have their own parameters.}

\item{qualities}{[\code{list}]\cr
Qualities of the algorithm. Each member of the list is an \code{OMLFlowQuality}.}

\item{tags}{[\code{character}]\cr
Tags describing the algorithm.}

\item{source.url}{[\code{character(1)}]\cr
URL from which the source code can be downloaded. Added by the server. Ignored when uploaded manually.}

\item{binary.url}{[\code{character(1)}]\cr
URL from which the binary can be downloaded. Added by the server. Ignored when uploaded manually.}

\item{source.format}{[\code{character(1)}]\cr
Format of the source file.}

\item{binary.format}{[\code{character(1)}]\cr
Format of the binary file.}

\item{source.md5}{[\code{character(1)}]\cr
MD5 checksum to check if the source code was uploaded correctly.}

\item{binary.md5}{[\code{character(1)}]\cr
MD5 checksum to check if the binary code was uploaded correctly.}

\item{source.path}{[\code{character(1)}]\cr
The path to the cached source file, once \code{\link{getOMLFlow}} was run.}

\item{binary.path}{[\code{character(1)}]\cr
The path to the cached binary file, once \code{\link{getOMLFlow}} was run.}

\item{object}{[\code{any}]\cr
(optional) Any R object referring to the flow.}
}
\description{
More details about the elements of a \code{OMLFlow} can be found in the
\href{https://github.com/openml/website/blob/master/openml_OS/views/pages/api_new/v1/xsd/openml.implementation.upload.xsd}{XSD scheme}.
}
\seealso{
Other flow-related functions: \code{\link{convertOMLFlowToMlr}},
  \code{\link{deleteOMLObject}}, \code{\link{getOMLFlow}},
  \code{\link{listOMLFlows}},
  \code{\link{makeOMLFlowParameter}},
  \code{\link{tagOMLObject}}
}

