% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOMLDataSetQualities.R
\name{getOMLDataSetQualities}
\alias{getOMLDataSetQualities}
\title{List available OpenML qualities with values for given data set.}
\usage{
getOMLDataSetQualities(data.id, verbosity = NULL, name = NULL)
}
\arguments{
\item{data.id}{[\code{integer(1)}]\cr
ID of the data set.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}

\item{name}{[\code{character}]\cr
Returns only the data qualities from \dQuote{name} (see also \code{\link{listOMLDataSetQualities}}).
Default is \code{NULL} and uses all available data qualities.}
}
\value{
[\code{data.frame}].
}
\description{
The returned \code{data.frame} contains data set quality
\dQuote{name}s and values \dQuote{value}.
}
\examples{
\dontrun{
  a = getOMLDataSetQualities(data.id = 9)
  a[a$name == "number.of.missing.values", ]
  getOMLDataSetQualities(data.id = 9, name = "number.of.missing.values")
}
}
\seealso{
Other downloading functions: \code{\link{getOMLDataSet}},
  \code{\link{getOMLFlow}}, \code{\link{getOMLRun}},
  \code{\link{getOMLTask}}
}

