% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_UMVUE_GMS_subset_second_total}
\alias{get_UMVUE_GMS_subset_second_total}
\title{Calculates the "uniformly minimal variance unbiased estimator".}
\usage{
get_UMVUE_GMS_subset_second_total(t, u, r1, n1, n)
}
\arguments{
\item{t}{observed responses in the subset endpoint.}

\item{u}{observed responses in the superset endpoint.}

\item{r1}{critical value for the first stage.}

\item{n1}{sample size for the first stage.}

\item{n}{overall sample size.}
}
\description{
Calculates the "uniformly minimal variance unbiased estimator" (UMVUE) for the true response rate for the superset endpoint.
}
\examples{
\dontrun{
#Setup "sub1"-object
sub1 <- setupSub1Design(pc0 = 0.5, pt0 = 0.6)

#Calculate a subset design
design <- getSolutionsSub1(sub1, skipN1 = FALSE)$Solutions[4,]

#Assume 9 responses in the subset endpoint and 13 responses in the superset endpoint were observed.
t = 9
u = 13
umvue_second <- get_UMVUE_GMS_subset_second_total(t, u, design$r1, design$n1, design$n)
}
}

