% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimal.KJ.beta1.r
\name{Optimal.KJ}
\alias{Optimal.KJ}
\title{Optimal Two-Stage Design Using One-Sample Log-Rank Test with Unrestricted Follow-Up}
\usage{
Optimal.KJ(dist, shape, S0, x0, hr, tf, rate, alpha, beta)
}
\arguments{
\item{dist}{distribution options with 'WB' as Weibull, 'GM' as Gamma, 'LN' as log-normal, 'LG' as log-logistic.}

\item{shape}{shape parameter for the baseline hazard function assuming one of the four parametric distributions ('WB', 'GM', 'LN' and 'LG').}

\item{S0}{survival probability at the fixed time point x0 under the null hypothesis.}

\item{x0}{a fixed time point where the survival probability is S0 under null.}

\item{hr}{hazard ratio, s1=s0^hr where s1 is the survival probability under HA and s0 is that under H0.}

\item{tf}{unrestricted follow-up time, the time period from the entry of the last patient to the end of the trial. If tf is too long, the function might throw an error.}

\item{rate}{a constant accrual rate. Please consider use a reasonable rate value. If the rate is too small, the function might throw an error.}

\item{alpha}{type I error.}

\item{beta}{type II error.}
}
\value{
\emph{nsignle} the required sample size for the single-stage design.\cr
\emph{tasingle} the estimated  accrual time for the single-stage design.\cr
\emph{csingle} the critical value for the single-stage design.\cr
\emph{n1} and \emph{n} required sample sizes in the two-stage design for the interim and final stage, respectively.\cr
\emph{c1} and \emph{c} critical values in two-stage designs for interim and final analysis, respectively.\cr
\emph{t1} the interim analysis time in the two-stage design.\cr
\emph{MTSL} the maximum total study length (the sum of accrual time and unrestricted follow-up time).\cr
\emph{ES} the expected sample size under null in the two-stage design.\cr
\emph{PS} the probability of early stopping under null in the two-stage design.
}
\description{
Optima.KJ() calculates the design parameters (e.g., t1, n1, n, c1, c) in the optimal two-stage design with unrestricted follow-up based on the one-sample log-rank (OSLR) test.
}
\examples{
# 1. An example when solution can be found.
\donttest{Optimal.KJ(dist="WB", shape=1, S0=0.62, x0=2, hr=0.467, tf=2, rate=5,
                     alpha=0.05, beta=0.2)}
# $param
#   shape   S0    hr alpha beta rate x0 tf
# 1     1 0.62 0.467  0.05  0.2    5  2  2

# $Single_stage
#   nsingle tasingle  csingle
# 1      25        5 1.644854

# $Two_stage
#   n1     c1  n      c     t1 MTSL      ES     PS
# 1 16 -0.302 26 1.6135 3.0593  7.2 21.9187 0.3813

# 2. An example when rate is too small and solution can not be found.
# Optimal.KJ(dist="GM", shape=1, S0=0.62, x0=2, hr=0.467, tf=2, rate=0.1,
#                alpha=0.05, beta=0.2)

# Error: solution for ta in single stage cannot be found,
#        please try to use a faster rate or a shorter tf.
#
# The above message occurs because the accrual rate is too slow, try to use
# a more reasonable value for rate.

# 3. An example when tf is too long and solution can not be found.
# Optimal.KJ(dist="GM", shape=1, S0=0.62, x0=2, hr=0.467, tf=100, rate=5,
#      alpha=0.05, beta=0.2)
#
# Error: solution for ta in single stage cannot be found,
#        please try to use a faster rate or a shorter tf.
#
# The above error message occurs because tf is too long, try to use
# a more reasonable value for follow-up time.

}
\references{
Wu, J, Chen L, Wei J, Weiss H, Chauhan A. (2020). Two-stage phase II survival trial design. Pharmaceutical Statistics. 2020;19:214-229. https://doi.org/10.1002/pst.1983
}
