% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseConceptCounts.R
\name{summariseConceptCounts}
\alias{summariseConceptCounts}
\title{Summarise concept counts in patient-level data. Only concepts recorded during observation period are counted.}
\usage{
summariseConceptCounts(
  cdm,
  conceptId,
  countBy = c("record", "person"),
  concept = TRUE,
  interval = "overall",
  sex = FALSE,
  ageGroup = NULL,
  dateRange = NULL
)
}
\arguments{
\item{cdm}{A cdm object}

\item{conceptId}{List of concept IDs to summarise.}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{concept}{TRUE or FALSE. If TRUE code use will be summarised by concept.}

\item{interval}{Time interval to stratify by. It can either be "years", "quarters", "months" or "overall".}

\item{sex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{A list of ageGroup vectors of length two. Code use will be
thus summarised by age groups.}

\item{dateRange}{A list containing the minimum and the maximum dates
defining the time range within which the analysis is performed.}
}
\value{
A summarised_result object with results overall and, if specified, by
strata.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
