% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tablePopulationCharacteristics.R
\name{tablePopulationCharacteristics}
\alias{tablePopulationCharacteristics}
\title{Create a visual table from a summarise_population_characteristics result.}
\usage{
tablePopulationCharacteristics(result, type = "gt")
}
\arguments{
\item{result}{Output from summarisePopulationCharacteristics().}

\item{type}{Type of formatting output table, either "gt" or "flextable".}
}
\value{
A gt or flextable object with the summarised data.
}
\description{
Create a visual table from a summarise_population_characteristics result.
}
\examples{
\donttest{
cdm <- mockOmopSketch()

summarisedPopulation <- summarisePopulationCharacteristics(
  cdm = cdm,
  studyPeriod = c("2010-01-01", NA),
  sex = TRUE,
  ageGroup = list("<=60" = c(0, 60), ">60" = c(61, Inf))
)

summarisedPopulation |>
  suppress(minCellCount = 5) |>
  tablePopulationCharacteristics()

PatientProfiles::mockDisconnect(cdm = cdm)
}
}
