% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseRecordCount.R
\name{summariseRecordCount}
\alias{summariseRecordCount}
\title{Summarise record counts of an omop_table using a specific time interval. Only
records that fall within the observation period are considered.}
\usage{
summariseRecordCount(
  cdm,
  omopTableName,
  unit = "year",
  unitInterval = 1,
  ageGroup = NULL,
  sex = FALSE
)
}
\arguments{
\item{cdm}{A cdm_reference object.}

\item{omopTableName}{A character vector of omop tables from the cdm.}

\item{unit}{Time unit it can either be "year" or "month".}

\item{unitInterval}{Number of years or months to include within the same
interval.}

\item{ageGroup}{A list of age groups to stratify results by.}

\item{sex}{Whether to stratify by sex (TRUE) or not (FALSE).}
}
\value{
A summarised_result object.
}
\description{
Summarise record counts of an omop_table using a specific time interval. Only
records that fall within the observation period are considered.
}
\examples{
\donttest{
library(dplyr, warn.conflicts = FALSE)

cdm <- mockOmopSketch()

summarisedResult <- summariseRecordCount(
  cdm = cdm,
  omopTableName = c("condition_occurrence", "drug_exposure"),
  unit = "year",
  unitInterval = 10,
  ageGroup = list("<=20" = c(0,20), ">20" = c(21, Inf)),
  sex = TRUE
)

summarisedResult |>
  glimpse()

PatientProfiles::mockDisconnect(cdm = cdm)
}
}
