% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization.R
\name{norm_internal_cross_product}
\alias{norm_internal_cross_product}
\title{Internal function normalizing Olink Explore 3k to Olink Explore 3072}
\usage{
norm_internal_cross_product(
  ref_df,
  ref_samples,
  ref_name,
  ref_cols,
  not_ref_df,
  not_ref_name,
  not_ref_cols
)
}
\arguments{
\item{ref_df}{The reference dataset to be used in normalization (required).}

\item{ref_samples}{Character vector of sample identifiers to be used for
adjustment factor calculation in the reference dataset (required).}

\item{ref_name}{Project name of the reference dataset (required).}

\item{ref_cols}{Named list of column names in the reference dataset
(required).}

\item{not_ref_df}{The non-reference dataset to be used in normalization
(required).}

\item{not_ref_name}{Project name of the non-reference dataset (required).}

\item{not_ref_cols}{Named list of column names in the non-reference dataset
(required).}
}
\value{
Tibble or ArrowObject with a dataset with the following additional
columns:
\itemize{
\item{OlinkID_E3072:} Corresponding assay identifier from Olink Explore
3072.
\item{Project:} Project of origin.
\item{BridgingRecommendation:} Recommendation of whether the assay is
bridgeable or not. One of "NotBridgeable", "MedianCentering", or
"QuantileSmoothing".
\item{MedianCenteredNPX:} NPX values adjusted based on the median of the
pair-wise differences of NPX values between bridge samples.
\item{QSNormalizedNPX:} NPX values adjusted based on the quantile smoothing
normalization among bridge samples.
}
}
\description{
Internal function normalizing Olink Explore 3k to Olink Explore 3072
}
\author{
Klev Diamanti
}
