% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_one_non_parametric.R
\name{olink_one_non_parametric_posthoc}
\alias{olink_one_non_parametric_posthoc}
\title{Function which performs a Wilcox posthoc test per protein.}
\usage{
olink_one_non_parametric_posthoc(
  df,
  olinkid_list = NULL,
  variable,
  verbose = T
)
}
\arguments{
\item{df}{NPX data frame in long format with at least protein name (Assay), OlinkID, UniProt, Panel and a factor with at least 3 levels.}

\item{olinkid_list}{Character vector of OlinkID's on which to perform post hoc analysis. If not specified, all assays in df are used.}

\item{variable}{Single character value or character array.}

\item{verbose}{Logical. Default: True. If information about removed samples, factor conversion and final model formula is to be printed to the console.}
}
\value{
Tibble of posthoc tests for specified effect, arranged by ascending adjusted p-values.
}
\description{
Performs a posthoc test using rstatix::wilcox_test with Benjamini-Hochberg p-value adjustment per assay (by OlinkID) for each panel at confidence level 0.95.
See \code{olink_kruskal} for details of input notation. \cr\cr
The function handles both factor and numerical variables.
The posthoc test for a numerical variable compares the difference in medians of the outcome variable (default: NPX) for 1 standard deviation difference in the numerical variable, e.g.
median NPX at mean(numerical variable) versus median NPX at median(numerical variable) + 1*SD(numerical variable).
}
\examples{
\donttest{

library(dplyr)

npx_df <- npx_data1 \%>\% filter(!grepl('control',SampleID, ignore.case = TRUE))

#Kruskal-Wallis Test
kruskal_wallis_results <- olink_one_non_parametric(npx_df, "Site")

#Friedman Test
Friedman_results <- olink_one_non_parametric(npx_df, "Time", dependence = TRUE)

#Posthoc test for the results from Friedman Test
#Filtering out significant and relevant results.
significant_assays <- Friedman_results \%>\%
filter(Threshold == 'Significant') \%>\%
dplyr::select(OlinkID) \%>\%
distinct() \%>\%
pull()

#Posthoc
friedman_posthoc_results <- olink_one_non_parametric_posthoc(npx_df, variable = c("Time"),
olinkid_list = significant_assays)}

}
