% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{RCO}
\alias{RCO}
\title{A function to compute Relative Concentration index (RCO)}
\usage{
RCO(x, a = NULL, spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}

\item{a}{- a numeric vector containing the areas of spatial units}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) containing 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension) which contains the geographic information}
}
\value{
a matrix containing relative concentration index values
}
\description{
The relative concentration index, RCO, measures 
the share of space occupied by a group compared to another group.
The function can be used in two ways: to provide an area vector or a 
external geographic information source (spatial object or shape file).
}
\examples{
x <- GreHSize@data[ ,3:5]
ar <- area(GreHSize)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'

RCO(x, a = ar) 

RCO(x, spatobj = GreHSize)

RCO(x, folder = foldername, shape = shapename) 

}
\references{
Massey D. S. and Denton N. A. (1988) \emph{
The dimensions of residential segregation}. 
Social Forces 67(2),  pp. 281-315.
}
\seealso{
one-group concentration indices: 
\code{\link{Delta}},  \code{\link{ACO}}
}

