% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otplot.R
\name{otplot}
\alias{otplot}
\title{Visulize a partition on 2 dimensional space}
\usage{
otplot(data, labels, convex.hull = F, title = "", xlab = "",
  ylab = "", legend.title = "", legend.labels = NULL, add.text = T)
}
\arguments{
\item{data}{-- cordinates matrix of data.}

\item{labels}{-- cluster labels.}

\item{convex.hull}{-- logical. If it is \code{True}, the plot draws convex hull for each cluster.}

\item{title}{-- title}

\item{xlab}{-- xlab}

\item{ylab}{-- ylab}

\item{legend.title}{-- legend title}

\item{legend.labels}{-- legend labels}

\item{add.text}{-- default True}
}
\value{
none
}
\description{
This function plots a partition on 2 dimensional reduced space.
}
\examples{
data(sim1)
# the number of clusters.
C = 4
ens.data = ensemble(sim1$X[1:50,], nbs=50, clust_param=C, clustering="kmeans", perturb_method=1)

# find mean partition and uncertainty statistics.
ota = otclust(ens.data)
# calculate baseline method for comparison.
kcl = kmeans(sim1$X[1:50],C)

# align clustering results for convenience of comparison.
compar = align(cbind(sim1$z[1:50],kcl$cluster,ota$meanpart))
lab.match = lapply(compar$weight,function(x) apply(x,2,which.max))
kcl.algnd = match(kcl$cluster,lab.match[[1]])
ota.algnd = match(ota$meanpart,lab.match[[2]])
# plot the result on two dimensional space.
otplot(sim1$X[1:50,],ota.algnd,con=FALSE,title='Mean partition')   # mean partition by OTclust
}
