% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustCPS.R
\name{clustCPS}
\alias{clustCPS}
\title{CPS Analysis for cluster validation..}
\usage{
clustCPS(data, k, l = TRUE, pre = TRUE, noi = "after",
  cmethod = "kmeans", dimr = "PCA", vis = "tsne", ref = NULL,
  nPCA = 50, nEXP = 100)
}
\arguments{
\item{data}{-- data given in a matrix format, where rows are samples, and columns are variables.}

\item{k}{-- number of clusters.}

\item{l}{-- logical. If True, log-transforamtion will be carried out on the data.}

\item{pre}{-- logical. If True, pre-dimension reduction will be carried out based on the variance.}

\item{noi}{-- adding noise before or after the dimension reduction, choosing between "before" and "after", default "after".}

\item{cmethod}{-- clustering method, choosing from "kmeans" and "mclust", default "kmeans".}

\item{dimr}{-- dimension reduction technique, choose from "none" and "PCA", default "PCA".}

\item{vis}{-- the visualization method to be used, such as "tsne" and "umap", default "tsne". Also, you can provide your own visualization coordinates in a numeric matrix of two columns.}

\item{ref}{-- optional, clustering reuslt in a vector format and the first cluster is labeled as 1. If provided it will be used as the reference, if not we will generate one.}

\item{nPCA}{-- number of principal conponents to use, default 50.}

\item{nEXP}{-- number of perturbed clustering reuslts for CPS Analysis, default 100.}
}
\value{
a list used for mplot or cplot, in which tight_all is the overall tightness, member is the matrix used for the membership plot, set is the matrix for the covering point set plot, tight is the vector of cluster-wise tightness, vis is the visualization coordinates, and ref is the reference labels.
}
\description{
Covering Point Set Analysis for validating clustering results. It conducts alignment among different results and then calculates the covering point set. The return contains several statistics which can be directly used as input for mplot or cplot. If you want to design your own workflow, you can use function CPS instead.
}
\examples{
# CPS Analysis on validation of clustering result
data(YAN)
# Suppose you generate the visualization coordinates on your own
x1=matrix(seq(1,nrow(YAN),1),ncol=1)
x2=matrix(seq(1,nrow(YAN),1),ncol=1)
# Using nEXP=50 for illustration, usually use nEXP greater 100
y=clustCPS(YAN[,1:100], k=7, l=FALSE, pre=FALSE, noi="after",vis=cbind(x1,x2), nEXP = 50)
# visualization of the results
mplot(y,4)
}
