% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf.R
\name{conf}
\alias{conf}
\title{Construction of Binary Classifier Sensitivities}
\usage{
conf(predictionMap = NULL)
}
\arguments{
\item{predictionMap}{A PredictionMap object as it is returned by \code{\link{predictionMap}}-function. 
It is made up of a list of two matrices(pred and meta). Both matrices provide information on individual samples column-wise.
The rownames of the pred-matrix (e.g. [0vs1]) show the classes of the binary base classifier. The elements are the prediction result of a specific training.
The rows that correspond to base classifiers that would separate the same class consists of -1. Those rows are not used within the analysis.
The meta information connects the values in the pred-matrix to a specific fold, run and contains the original label.}
}
\value{
Object of class Conf. Consists of a list of two numeric matrices fC and sC.
}
\description{
Sensitivities of all pairwise binary classifiers for all classes.
}
\details{
The Conf object contains all class sensitivities for each binary trained classifiers. 
The $fC-part is a matrix with one column and contains the sensitivities for the first class 
of each pairwise classifier. The rows stand for the pairwise classifiers, whereby 
0vs1 means that this classifier was trained for class 0 against class 1, with 
class 0 being the first class. The number '-1' is used as placeholder. 
The $sC-part is a matrix and contains the preformance measures for all second classes, 
which are meant here as all classes except the first class. The rows correspond 
to the binary classifiers and the columns to the classes.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')

conf = conf(predMap)
}
\seealso{
\code{\link{summary.Conf}}, \code{\link{print.Conf}}, \code{\link{plot.Conf}}
}
