% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Octopus600.r
\name{opiPresent_for_O600}
\alias{opiPresent_for_O600}
\title{Implementation of opiPresent for the O600 machine.}
\arguments{
\item{stim}{Stimulus to present which is a list with the following elements:
\itemize{
\item \code{x}  positionX (in 1/10deg)
\item \code{y}  positionY (in 1/10deg)
\item \code{level} dLog (intensity; 0dB is 4000 apostilbs) (in 1/10 dB)
\item \code{duration} Stimulus presentation duration in ms, for W/W 100ms, for pulsar 500ms
\item \code{responseWindow} Maximal allowed reaction time in ms, >=500ms and <4s
\item \code{sound} # Bit 1 = sound for patient response button ON; Bit2=1 sound for fixation lost ON
}}

\item{nextStim}{The stimulus to present after stim
(it is not presented, but projector can move to it during response window)}
}
\value{
A list containing
\itemize{
\item \code{err}  String message or NULL for no error.
\item \code{seen} 1 if seen, 0 otherwise.
\item \code{time} Reaction time (if seen).
}
}
\description{
This is for internal use only. Use \code{\link[=opiPresent]{opiPresent()}} with the same arguments.
}
\examples{
\dontrun{
  chooseOpi("O600")
  if (!is.null(opiInitialize()$err))
      stop("opiInitialize failed")
  s <- list(x=9, y=9, level=dbTocd(db), size=0.43, color="white",
            duration=200, responseWindow=1500, checkFixationOK=NULL)
  print(opiPresent(s, NULL))
}


}
