% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sulfur.R, R/sulpher.R
\name{calc_sbal_arable}
\alias{calc_sbal_arable}
\title{Calculate the indicator for delta S-balance arable}
\usage{
calc_sbal_arable(D_SLV, B_LU_BRP, B_SOILTYPE_AGR, B_AER_CBS)

calc_sbal_arable(D_SLV, B_LU_BRP, B_SOILTYPE_AGR, B_AER_CBS)
}
\arguments{
\item{D_SLV}{(numeric) The value of SLV  calculated by \code{\link{calc_slv}}}

\item{B_LU_BRP}{(numeric) The crop code (gewascode) from the BRP}

\item{B_SOILTYPE_AGR}{(character) The type of soil}

\item{B_AER_CBS}{(character) The agricultural economic region in the Netherlands (CBS, 2016)}
}
\value{
Estimated contribution of the soil to the S balance of arable fields. A numeric value.

Estimated contribution of the soil to the S balance of arable fields. A numeric value.
}
\description{
This function calculates the change in S-balance compared to averaged S-supply as given in fertilizer recommendation systems.

This function calculates the change in S-balance compared to averaged S-supply as given in fertilizer recommendation systems.
}
\examples{
calc_sbal_arable(D_SLV = 65, B_LU_BRP = 1019, B_SOILTYPE_AGR = 'dekzand', 
B_AER_CBS = 'Rivierengebied')
calc_sbal_arable(65, 1019, 'dekzand', 'Rivierengebied')
calc_sbal_arable(c(65,125), c(265,1019), rep('dekzand',2), rep('Rivierengebied',2))

calc_sbal_arable(D_SLV = 65, B_LU_BRP = 1019, B_SOILTYPE_AGR = 'dekzand', 
B_AER_CBS = 'Rivierengebied')
calc_sbal_arable(65, 1019, 'dekzand', 'Rivierengebied')
calc_sbal_arable(c(65,125), c(265,1019), rep('dekzand',2), rep('Rivierengebied',2))

}
