% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESTAR_ECM.R
\name{ESTAR_ECM}
\alias{ESTAR_ECM}
\title{STAR Vector Error Correction Model}
\usage{
ESTAR_ECM(y, x, lags)
}
\arguments{
\item{y}{series name,}

\item{x}{series name}

\item{lags}{lag length}
}
\value{
"Model" Estimated model

"AIC" Akaike information criteria

"BIC" Schwarz information criteria
}
\description{
This function allows you to estimate ESTAR Vector Error Correction Model
}
\details{
Exponential smooth transition error correction model as follows:
}
\examples{
x <- cumsum(rnorm(1000))
y <- cumsum(rnorm(1000))
ESTAR_ECM(x, y, lags = 6)

data(MarketPrices)
ESTAR_ECM(MarketPrices[,1],MarketPrices[,2],lags = 2)

}
\references{
Kapetanios, G., Shin, Y., & Snell, A. (2006). Testing for cointegration in nonlinear smooth transition error correction models. Econometric Theory, 22(2), 279-303.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{STAR}
\keyword{correction}
\keyword{error}
\keyword{model}
\keyword{vector}
