% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kstepmalgorithm.R
\name{kStepMAlgorithm}
\alias{kStepMAlgorithm}
\title{k-StepM Algorithm for Hypothesis Testing}
\usage{
kStepMAlgorithm(original_stats, bootstrap_stats, num_hypotheses, alpha, k)
}
\arguments{
\item{original_stats}{A numeric vector of original test statistics for each hypothesis.}

\item{bootstrap_stats}{A numeric matrix of bootstrap test statistics, with rows representing
bootstrap samples and columns representing hypotheses.}

\item{num_hypotheses}{An integer specifying the total number of hypotheses.}

\item{alpha}{A numeric value specifying the significance level.}

\item{k}{An integer specifying the threshold number for controlling the k-familywise error rate.}
}
\value{
A list containing two elements: 'signif', a logical vector indicating which hypotheses
        are rejected, and 'cv', a numeric vector of critical values used for each hypothesis.
}
\description{
This function implements the k-stepM algorithm for multiple hypothesis testing.
It tests each hypothesis using the critical value calculated from the ECDF
of the k-max differences, updating the critical value, and iterating until all hypotheses
are tested.
}
\examples{
original_stats <- rnorm(10)
bootstrap_stats <- matrix(rnorm(1000), ncol = 10)
result <- kStepMAlgorithm(original_stats, bootstrap_stats, 10, 0.05, 1)
}
\references{
Romano, Joseph P., Azeem M. Shaikh, and Michael Wolf. "Formalized data snooping
based on generalized error rates." Econometric Theory 24.2 (2008): 404-447.
}
