% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HessMLP.R
\name{print.summary.HessMLP}
\alias{print.summary.HessMLP}
\title{Print method of the summary HessMLP Class}
\usage{
\method{print}{summary.HessMLP}(x, round_digits = NULL, ...)
}
\arguments{
\item{x}{\code{summary.HessMLP} object created by summary method of \code{HessMLP} object}

\item{round_digits}{\code{integer} number of decimal places, default \code{NULL}}

\item{...}{additional parameters}
}
\description{
Print the sensitivity metrics of a \code{HessMLP} object.
This metrics are the mean sensitivity, the standard deviation
of sensitivities and the mean of sensitivities square
}
\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR

## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                           data = nntrData,
                           linear.output = TRUE,
                           size = hidden_neurons,
                           decay = decay,
                           maxit = iters)
# Try HessianMLP
sens <- NeuralSens::HessianMLP(nnetmod, trData = nntrData, plot = FALSE)
print(summary(sens))
}
