% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotSensMLP.R
\name{PlotSensMLP}
\alias{PlotSensMLP}
\title{Neural network structure sensitivity plot}
\usage{
PlotSensMLP(
  MLP.fit,
  metric = "mean",
  sens_neg_col = "red",
  sens_pos_col = "blue",
  ...
)
}
\arguments{
\item{MLP.fit}{fitted neural network model}

\item{metric}{metric to plot in the NID. It can be "mean" (default), "median or "sqmean".
It can be any metric to combine the raw sensitivities}

\item{sens_neg_col}{\code{character} string indicating color of negative sensitivity
measure, default 'red'. The same is passed to argument \code{neg_col} of
\link[NeuralNetTools:plotnet]{plotnet}}

\item{sens_pos_col}{\code{character} string indicating color of positive sensitivity
measure, default 'blue'. The same is passed to argument \code{pos_col} of
\link[NeuralNetTools:plotnet]{plotnet}}

\item{...}{additional arguments passed to \link[NeuralNetTools:plotnet]{plotnet} and/or
\link[NeuralSens:SensAnalysisMLP]{SensAnalysisMLP}}
}
\value{
A graphics object
}
\description{
Plot a neural interpretation diagram colored by sensitivities
of the model
}
\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR
## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 100
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                      data = nntrData,
                      linear.output = TRUE,
                      size = hidden_neurons,
                      decay = decay,
                      maxit = iters)
# Try SensAnalysisMLP
NeuralSens::PlotSensMLP(nnetmod, trData = nntrData)
}
