% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smallworldness.R
\name{smallworldness}
\alias{smallworldness}
\title{Small-worldness Measure}
\usage{
smallworldness(A, iter = 100, progBar = FALSE, method = c("HG",
  "rand", "TJHBL"))
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{iter}{Number of random (or lattice) networks to generate,
which are used to calculate the mean random ASPL and CC (or lattice)}

\item{progBar}{Defaults to \code{FALSE}.
Set to \code{TRUE} to see progress bar}

\item{method}{Defaults to \code{"HG"} (Humphries & Gurney, 2008).
Set to \code{"rand"} for the CC to be calculated using a random network or
set to \code{"TJHBL"} for (Telesford et al., 2011) where CC is calculated from a lattice network}
}
\value{
Returns a list containing:

\item{swm}{Small-worldness value}

\item{rASPL}{Global average shortest path length from random network}

\item{lrCCt}{When \code{"rand"}, clustering coefficient from a random network.
When \code{"HG"}, transitivity from a random network.
When \code{"TJHBL"}, clustering coefficient from a lattice network}
}
\description{
Computes the small-worldness measure of a network
}
\details{
For \code{"rand"}, values > 1 indicate a small-world network.
For \code{"HG"}, values > 3 indicate a small-world network.
For \code{"TJHBL"}, values near 0 indicate a small-world network,
while < 0 indicates a more regular network and > 0 indicates a more random network
}
\examples{
# normal set to FALSE for CRAN tests
A<-TMFG(neoOpen, normal = FALSE)$A

swmHG <- smallworldness(A, method="HG")

swmRand <- smallworldness(A, method="rand")

swmTJHBL <- smallworldness(A, method="TJHBL")

}
\references{
Humphries, M. D., & Gurney, K. (2008).
Network 'small-world-ness': A quantitative method for determining canonical network equivalence.
\emph{PLoS one}, \emph{3}, e0002051.
doi: \href{https://doi.org/10.1371/journal.pone.0002051}{10.1371/journal.pone.0002051}

Telesford, Q. K., Joyce, K. E., Hayasaka, S., Burdette, J. H., & Laurienti, P. J. (2011).
The ubiquity of small-world networks.
\emph{Brain Connectivity}, \emph{1}(5), 367-375.
doi: \href{https://doi.org/10.1089/brain.2011.0038}{10.1089/brain.2011.0038}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
