% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoGo.R
\name{LoGo}
\alias{LoGo}
\title{Local/Global Sparse Inverse Covariance Matrix}
\usage{
LoGo(data, cliques, separators, normal = FALSE, na.data = c("pairwise",
  "listwise", "fiml", "none"), partial = TRUE)
}
\arguments{
\item{data}{Must be a dataset}

\item{cliques}{Cliques defined in the network.
Input can be a list or matrix}

\item{separators}{Separators defined in the network.
Input can be a list or matrix}

\item{normal}{Should data be transformed to a normal distribution?
Defaults to FALSE.
Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \link[qgraph]{cor_auto} function)}

\item{na.data}{How should missing data be handled?
For "listwise" deletion the \code{\link{na.omit}} function is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\link[psych]{corFiml}).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{partial}{Should the output network's connections be the partial correlation between two nodes given all other nodes?
Defaults to TRUE, which returns a partial correlation matrix.
Set to FALSE for a sparse inverse covariance matrix}
}
\value{
Returns the sparse LoGo-filtered inverse covariance matrix (partial = FALSE)
or LoGo-filtered partial correlation matrix (partial = TRUE)
}
\description{
Applies the Local/Global method to estimate
the sparse inverse covariance matrix using a TMFG-filtered network
(\strong{see and cite Barfuss et al., 2016})
}
\examples{
LoGonet <- LoGo(neoOpen, partial = TRUE)

}
\references{
Barfuss, W., Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Parsimonious modeling with information filtering networks.
\emph{Physical Review E}, \emph{94}, 062306.
doi: \href{https://doi.org/10.1103/PhysRevE.94.062306}{10.1103/PhysRevE.94.062306}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
