% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{NetProps}
\alias{NetProps}
\title{Calculate the network properties}
\usage{
NetProps(data, net, moduleAssignments, modules)
}
\arguments{
\item{data}{data matrix from the dataset in which to calculate the network
properties.}

\item{net}{adjacency matrix of network edge weights between all pairs of 
nodes in the dataset in which to calculate the network properties.}

\item{moduleAssignments}{a named character vector containing the module 
each node belongs to in the discovery dataset.}

\item{modules}{a character vector of modules for which to calculate the 
network properties for.}
}
\value{
a list containing the summary profile, node contribution, module
  coherence, weighted degree, and average edge weight for each 'module'.
}
\description{
Calculate the network properties
}
\details{
\subsection{Input expectations:}{
  Note that this function expects all inputs to be sensible, as checked by
  the R function 'checkUserInput' and processed by 'networkProperties'. 
  
  These requirements are:
  \itemize{
  \item{The ordering of node names across 'data' and 'net' is consistent.}
  \item{The columns of 'data' are the nodes.}
  \item{'net' is a square matrix, and its rownames are identical to its 
        column names.}
  \item{'moduleAssigments' is a named character vector, where the names
        represent node labels found in the discovery dataset. Unlike 
        'PermutationProcedure', these may include nodes that are not 
        present in 'data' and 'net'.}
  \item{The module labels specified in 'modules' must occur in 
        'moduleAssignments'.}
  }
}
}

