% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mmsbm.R
\name{summary.mmsbm}
\alias{summary.mmsbm}
\title{Summarize 'mmsbm' object}
\usage{
\method{summary}{mmsbm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{mmsbm}, a result of a call to \code{mmsbm}.}

\item{...}{Currently ignored}
}
\value{
List with named components:
    \describe{
      \item{N}{Total number of dyad-time period observations.}
      \item{Number of Clusters}{Number of latent groups included in the dynMMSBM model.}
      \item{Percent of Observations in Each Cluster}{Average membership in each latent group, across all node-time periods.}
      \item{Edge Formation Probabilities}{\code{n.groups} by \code{n.groups} matrix of estimated edge formation probabilities between latent groups.}
      \item{Dyadic Coefficients}{Vector of estimated coefficient values for dyadic covariates.}
      \item{Monadic Coefficients}{Array of estimated coefficient values for monadic covariates. Has \code{n.groups} columns,
                       and \code{n.hmmstates} slices.}
      \item{Markov State Probabilities}{Average HMM state probabilities across all time periods.}
    }
}
\description{
The function summarizes the output of a dynMMSBM model object
}
\examples{
library(NetMix)
## Load datasets
data("lazega_dyadic")
data("lazega_monadic")
## Estimate model with 2 groups
set.seed(123)
lazega_mmsbm <- mmsbm(SocializeWith ~ Coworkers,
                      ~  School + Practice + Status,
                      senderID = "Lawyer1",
                      receiverID = "Lawyer2",
                      nodeID = "Lawyer",
                      data.dyad = lazega_dyadic,
                      data.monad = lazega_monadic,
                      n.blocks = 2)

## Summarize estimated model
summary(lazega_mmsbm)

}
\author{
Kosuke Imai (imai@harvard.edu), Tyler Pratt (tyler.pratt@yale.edu), Santiago Olivella (olivella@unc.edu)
}
